/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.item;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class MessageInABottleItem
extends BlockItem {
    public MessageInABottleItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (world.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
        }
        Random random = new Random();
        int randomNumber = random.nextInt(100);
        ItemStack itemStack = randomNumber < 50 ? new ItemStack((ItemLike)Items.f_42516_) : (randomNumber < 80 ? new ItemStack((ItemLike)Items.f_42676_) : MessageInABottleItem.getRandomMap((Entity)user));
        if (itemStack == null) {
            itemStack = new ItemStack((ItemLike)Items.f_42516_);
        }
        ItemEntity entity = new ItemEntity(world, user.m_20185_(), user.m_20186_(), user.m_20189_(), itemStack);
        world.m_7967_((Entity)entity);
        ItemStack glassBottleStack = new ItemStack((ItemLike)Items.f_42590_, 1);
        ItemEntity glassBottleEntity = new ItemEntity(world, user.m_20185_(), user.m_20186_(), user.m_20189_(), glassBottleStack);
        world.m_7967_((Entity)glassBottleEntity);
        user.m_21120_(hand).m_41774_(1);
        return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
    }

    @Nullable
    public static ItemStack getRandomMap(Entity entity) {
        int lootChest = entity.f_19853_.m_213780_().m_188503_(4);
        ItemStack map = null;
        switch (lootChest) {
            case 0: {
                map = MessageInABottleItem.createMansionMap(entity);
                break;
            }
            case 1: {
                map = MessageInABottleItem.createShipwreckMap(entity);
                break;
            }
            case 2: {
                map = MessageInABottleItem.createMonumentMap(entity);
                break;
            }
            case 3: {
                map = MessageInABottleItem.createTreasureMap(entity);
            }
        }
        return map;
    }

    public static ItemStack createMonumentMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.f_215885_, "filled_map.monument", MapDecoration.Type.MONUMENT);
    }

    public static ItemStack createMansionMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.f_215884_, "filled_map.mansion", MapDecoration.Type.MANSION);
    }

    public static ItemStack createShipwreckMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.f_215891_, "filled_map.shipwreck", MapDecoration.Type.RED_X);
    }

    public static ItemStack createTreasureMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.f_215886_, "filled_map.treasure", MapDecoration.Type.RED_X);
    }

    @Nullable
    public static ItemStack createMap(Entity entity, TagKey<Structure> structure, String nameKey, MapDecoration.Type iconType) {
        Level level = entity.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        BlockPos blockPos = serverWorld.m_215011_(structure, entity.m_20183_(), 100, true);
        if (blockPos != null) {
            ItemStack itemStack = MapItem.m_42886_((Level)serverWorld, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)serverWorld, (ItemStack)itemStack);
            MapItemSavedData.m_77925_((ItemStack)itemStack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)iconType);
            itemStack.m_41714_((Component)Component.m_237115_((String)nameKey));
            return itemStack;
        }
        return null;
    }
}

